package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class HorizontalBlockScreenObject extends MobileScreenObject implements CloneableScreenObject {

	private IntRect clickRect;
	
	private boolean isSelected;
	
	private boolean shouldBePassthru;
	
	
	private HorizontalBlockScreenPaletteObject paletteObject;
	
	
	
	public HorizontalBlockScreenObject(int x, int y, int width, int height, HorizontalBlockScreenPaletteObject thePaletteObject, boolean passThru, int theSpeed) {
		
		paletteObject = thePaletteObject;
		
		clickRect = new IntRect(x - width/2, y - height/2, width, height);
		isSelected = false;
		shouldBePassthru = passThru;
		setSpeed(theSpeed);
		
		this.setVertical(false);
		
		this.setMin(x);
		this.setMax(x);
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		if(paletteObject.getImage() != null) {
			
			Point center = clickRect.getCenter();
			
			Color origColor = g.getColor();
			
			g.setColor(new Color(0, 255, 0));
			g.drawLine(center.x, center.y - 5, this.getMin(), center.y - 5);
			g.drawLine(center.x, center.y + 5, this.getMin(), center.y + 5);
			
			g.setColor(new Color(51, 255, 0));
			g.drawLine(center.x, center.y - 4, this.getMin(), center.y - 4);
			g.drawLine(center.x, center.y + 4, this.getMin(), center.y + 4);
			
			g.setColor(new Color(102, 255, 0));
			g.drawLine(center.x, center.y - 3, this.getMin(), center.y - 3);
			g.drawLine(center.x, center.y + 3, this.getMin(), center.y + 3);
			
			g.setColor(new Color(153, 255, 0));
			g.drawLine(center.x, center.y - 2, this.getMin(), center.y - 2);
			g.drawLine(center.x, center.y + 2, this.getMin(), center.y + 2);
			
			g.setColor(new Color(204, 255, 0));
			g.drawLine(center.x, center.y - 1, this.getMin(), center.y - 1);
			g.drawLine(center.x, center.y + 1, this.getMin(), center.y + 1);
			
			g.setColor(new Color(255, 255, 0));
			g.drawLine(center.x, center.y, this.getMin(), center.y);
			g.drawLine(this.getMin(), center.y - 10, this.getMin(), center.y + 10);
			
			
			
			g.setColor(new Color(0, 0, 255));
			g.drawLine(center.x, center.y - 5, this.getMax(), center.y - 5);
			g.drawLine(center.x, center.y + 5, this.getMax(), center.y + 5);
			
			g.setColor(new Color(51, 0, 255));
			g.drawLine(center.x, center.y - 4, this.getMax(), center.y - 4);
			g.drawLine(center.x, center.y + 4, this.getMax(), center.y + 4);
			
			g.setColor(new Color(102, 0, 255));
			g.drawLine(center.x, center.y - 3, this.getMax(), center.y - 3);
			g.drawLine(center.x, center.y + 3, this.getMax(), center.y + 3);
			
			g.setColor(new Color(153, 0, 255));
			g.drawLine(center.x, center.y - 2, this.getMax(), center.y - 2);
			g.drawLine(center.x, center.y + 2, this.getMax(), center.y + 2);
			
			g.setColor(new Color(204, 0, 255));
			g.drawLine(center.x, center.y - 1, this.getMax(), center.y - 1);
			g.drawLine(center.x, center.y + 1, this.getMax(), center.y + 1);
			
			g.setColor(new Color(255, 0, 255));
			g.drawLine(center.x, center.y, this.getMax(), center.y);
			g.drawLine(this.getMax(), center.y - 10, this.getMax(), center.y + 10);
			
			
			
			g.setColor(origColor);
			
			paletteObject.getImage().drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		}

		drawInitialDirIndicator(g);
		
		if(isSelected)
			drawSelectionOverObject(g);
		
		
		
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}



	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}



	public boolean shouldBePassthru() {
		return shouldBePassthru;
	}



	public void setShouldBePassthru(boolean shouldBePassthru) {
		this.shouldBePassthru = shouldBePassthru;
	}
	
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("movingBlock:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("width:");
		out.write(Integer.toString(this.getClickRect().width()));
		out.newLine();
		
		out.write("height:");
		out.write(Integer.toString(this.getClickRect().height()));
		out.newLine();
		
		out.write("graphic:");
		out.write(this.paletteObject.getImage().getFileName());
		out.newLine();
		
		if(this.paletteObject.shouldBePassThru()) {
			out.write("passThru");
		} else {
			out.write("solid");
		}
		out.newLine();
		
		out.write("transparent:");
		out.write(CustomAnimationPanel.convertColorToString(paletteObject.getImage().getTransparentColor()));
		out.newLine();
		
		out.write("dir:");
		if(this.isGoingMinDirection()) {
			out.write("l");
		} else {
			out.write("r");
		}
		out.newLine();
		
		out.write("minX:");
		out.write(Integer.toString(this.getMin()));
		out.newLine();
		
		out.write("maxX:");
		out.write(Integer.toString(this.getMax()));
		out.newLine();
		
		out.write("horizontal");
		out.newLine();
		
		out.write("speed:");
		out.write(Integer.toString(this.getSpeed()));
		out.newLine();
		
		out.write("defaultSpeed:");
		out.write(Integer.toString(this.paletteObject.getDefaultSpeed()));
		out.newLine();
		
		out.write("/movingBlock");
		out.newLine();
		
		out.newLine();
	}
	
	public HorizontalBlockScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		
		HorizontalBlockScreenObject returnValue = new HorizontalBlockScreenObject(centerPoint.x, centerPoint.y, clickRect.width(), clickRect.height(), this.paletteObject, this.paletteObject.shouldBePassThru(), this.getSpeed());
		returnValue.setMax(this.getMax());
		returnValue.setMin(this.getMin());
		returnValue.setGoingMinDirection(this.isGoingMinDirection());
		
		return returnValue;
		
		
	}

	
	
	@Override
	public int getLayer() {
		
		return 7;
	}
}
